#!/usr/bin/python3
'''
 Шаблон для размещения виджетов (в том числе и эластичных)
 в одном горизонтальном и двух вертикальных фреймах.
 Управление эластичностью  виджетов выполняется в упаковке
 параметрами fill и expand. Рекомендуется сетку Grid всегда
 создавать в отдельном фрейме 
'''
from tkinter import *
from tkinter import ttk

# ------------------------------------------------
root=Tk()
root.geometry('800x320')
root.title('Шаблон: 1-horizontal, 2-vernical (2-horizontal) frames')

w = root.winfo_screenwidth()    # ширина экрана
h = root.winfo_screenheight()   # высота экрана

tab1 = []                       # 2D-таблица в Grid
numrow, numcol = 8, 4           # число строк и столбцов в таблице tab1

# Подготовим три фрейма 
frameT=ttk.Frame(root, padding=[8, 10], relief=SUNKEN)
frameL=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)
frameR=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)
# Определим порядок фреймов на root
frameT.pack(side='top',  fill='x',    expand='no')
frameL.pack(side='left', fill='both', expand='yes')
frameR.pack(side='left', fill='both', expand='no')
# Подготовим виджеты,  свяжем их с фреймами,
# определим вид эластичности
labelT=Label(frameT ,text='Screen rezolution ')
labelT.pack(side='left')

labe2T=Label(frameT ,text=' width :' + str(w) + ' ', relief=SUNKEN)
labe2T.pack(side='left')

labe3T=Label(frameT ,text=' height :' + str(h) + ' ', relief=SUNKEN)
labe3T.pack(side='left')

labelL=Label(frameL ,text='Text title')
labelL.pack(side='top', fill='x', expand='no')

textL = Text(frameL, height=4, width=10)
textL.pack(side='left', fill="both", expand='yes')
wstr = '''
 Шаблон для размещения виджетов (в том числе и эластичных)
 в одном горизонтальном и двух вертикальных фреймах.
 Управление эластичностью  виджетов выполняется в упаковке
 параметрами fill и expand. Рекомендуется сетку Grid всегда
 создавать в отдельном фрейме 
'''
textL.insert(END,wstr)

frameRT=ttk.Frame(frameR, padding=[8, 10],relief=SUNKEN)
frameRT.pack(side='top', expand='no')
# Создадим и инициируем  tab1 в сетке
for r in range(numrow):
    cols = []
    for c in range(numcol):
        ent = Entry(frameRT, width=10, relief=RIDGE)
        ent.grid(row=r, column=c, sticky=EW)
        ent.insert(END, '%d.%d' % (r, c))
        cols.append(ent)
    tab1.append(cols)
    
frameRB=ttk.Frame(frameR, padding=[8, 10], relief=SUNKEN)
frameRB.pack(side='left', fill="both", expand='yes')

labelRB1=Label(frameRB ,text='Надпись 1', relief=SUNKEN)
labelRB1.pack(side='top', fill="x", expand='no')

labelRB2=Label(frameRB ,text='Надпись 2', relief=SUNKEN)
labelRB2.pack(side='left', fill="x", expand='no')

labelRB3=Label(frameRB ,text='Надпись 3', relief=SUNKEN)
labelRB3.pack(side='left', fill="x", expand='yes')

# ------------------------------------------------
root.mainloop ()
