#!/usr/bin/python3
'''
 Шаблон для размещения виджетов (в том числе и эластичных)
 в одном горизонтальном и двух вертикальных фреймах.
 Управление эластичностью  виджетов выполняется в упаковке
 параметрами fill и expand. Рекомендуется сетку Grid всегда
 создавать в отдельном фрейме, поэтому правый ветрикальный
 фрейм разобъем на два горизонтальных фрейма.
'''
from tkinter import *
from tkinter import ttk

# ------------------------------------------------
# Имитатор отображения прогресса
def onStart(pb) :
    pb.start(100)   # Параметр: время задержки шага прогресса в мсек 
def onStop(pb) :    
    pb.stop()
# ------------------------------------------------
root=Tk()
root.geometry('700x320')
root.title('Шаблон: 1-horizontal, 2-vernical (2-horizontal) frames')

w = root.winfo_screenwidth()    # ширина экрана
h = root.winfo_screenheight()   # высота экрана

tab1 = []                       # 2D-таблица в Grid
numrow, numcol = 8, 4           # число строк и столбцов в таблице tab1

# Подготовим три фрейма 
frameT=ttk.Frame(root, padding=[8, 10], relief=SUNKEN)
frameL=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)
frameR=ttk.Frame(root, padding=[8, 10],relief=SUNKEN)
# Определим порядок фреймов на root
frameT.pack(side='top',    fill='x',    expand='no')
frameL.pack(side='left',   fill='both', expand='yes')
frameR.pack(side='left',   fill='both', expand='yes')
# Подготовим виджеты,  свяжем их с фреймами,
# определим вид эластичности
labelT=Label(frameT ,text='Screen rezolution ')
labelT.pack(side='left')

labe2T=Label(frameT ,text=' width :' + str(w) + ' ', relief=SUNKEN)
labe2T.pack(side='left')

labe3T=Label(frameT ,text=' height :' + str(h) + ' ', relief=SUNKEN)
labe3T.pack(side='left')

labelL=Label(frameL ,text='Text title')
labelL.pack(side='top', fill='x', expand='no')

textL = Text(frameL, height=8, width=16)
textL.pack(side='left', fill="both", expand='yes')

# В правом фрейме создадим два горизонтальных sub-фрейма
# Фрейм для сетки
FrmR1=ttk.Frame(frameR, padding=[8, 10], relief=SUNKEN)
FrmR1.pack(side='top', fill='both', expand='yes')
for r in range(numrow):
    cols = []
    for c in range(numcol):
        ent = Entry(FrmR1, relief=RIDGE)
        ent.grid(row=r, column=c, sticky=NSEW)
        ent.insert(END, '%d.%d' % (r, c))
        cols.append(ent)
    tab1.append(cols)
FrmR1=Frame(frameR)
# Фрейм для Progressbar
FrmR2=ttk.Frame(frameR, padding=[8, 10], relief=SUNKEN)
FrmR2.pack(side='bottom', fill='x', expand='no')
labelD=Label(FrmR2, text='Progressbar title')
labelD.pack(side='top', fill='x', expand='yes')
ButStart = Button(FrmR2, text='Start Progress', command=(lambda: onStart(pbD)))
ButStart.pack(side="left")
ButStop  = Button(FrmR2, text='Stop  Progress', command=(lambda: onStop(pbD)))
ButStop.pack(side="left")
pbD = ttk.Progressbar (FrmR2, length=400)
pbD.pack(side="left", fill="x", expand='yes')

# ------------------------------------------------
root.mainloop ()
